<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Donation_requests()
    {
        return $this->hasMany('App\Models\DonationRequest', 'donation_request_id');
    }

    public function clients()
    {
        return $this->belongsToMany('App\Models\Client', 'client_notification');
    }

}